/********************************************************
** Copyright 1999 Earth Resource Mapping Ltd.
** This document contains proprietary source code of
** Earth Resource Mapping Ltd, and can only be used under
** one of the three licenses as described in the 
** license.txt file supplied with this distribution. 
** See separate license.txt file for license details 
** and conditions.
**
** This software is covered by US patent #6,442,298,
** #6,102,897 and #6,633,688.  Rights to use these patents 
** is included in the license agreements.
**
** FILE:   	NCSUtil.h
** CREATED:	Thu Feb 25 09:19:00 WST 1999
** AUTHOR: 	Simon Cope
** PURPOSE:	NCS Utility library header.
** EDITS:
** [01] ny  23May00 Modified NCSGetUserAndDomainName to be cross platform
** [02] ny  30Oct00 Merge CE/Palm modification in preparation for Macintosh port
** [03] ny  23Nov00 Mac port changes (Added NCSstrcasecmp)
** [04] sjc 28Aug01 Added NCSIsService() to detect if running as a service under WinNT/2K/XP Server.
** [05] sjc 11Mar02 Added NCSIsWebService() to detect if running as a web service under WinNT/2K/XP Server.
** [06] ajd 01Jul02 Added NCSNanVal() to generate NaNs
** [07] sjc 12Feb03	Added NCSLog2() to calculate log2() function
 *******************************************************/

#ifndef NCSUTIL_H
#define NCSUTIL_H

// FIXME					/**[02]**/
#ifdef __PALM__				/**[02]**/
#ifndef EMULATION_LEVEL		/**[02]**/
#define EMULATION_LEVEL 0	/**[02]**/
#endif						/**[02]**/
#endif						/**[02]**/

#ifndef __PALM__			/**[02]**/
#include <math.h>
#endif						/**[02]**/

#ifndef NCSTYPES_H
#include "NCSTypes.h"
#endif
#ifndef NCSDEFS_H
#include "NCSDefs.h"
#endif
#ifndef NCSDYNAMICLIB_H
#include "NCSDynamicLib.h"
#endif
#ifndef NCSERRORS_H
#include "NCSErrors.h"
#endif
#ifndef NCSMALLOC_H
#include "NCSMalloc.h"
#endif
#ifndef NCSARRAY_H
#include "NCSArray.h"
#endif
#ifndef NCSTIMESTAMP_H
#include "NCSTimeStamp.h"
#endif
#ifndef NCSMUTEX_H
#include "NCSMutex.h"
#endif
#ifndef NCSMEMPOOL_H
#include "NCSMemPool.h"
#endif
#ifndef NCSUTIL_H
#include "NCSUtil.h"
#endif
#ifndef NCSTHREAD_H
#include "NCSThread.h"
#endif
#ifndef NCSQUEUE_H
#include "NCSQueue.h"
#endif
#ifndef NCSPACKETS_H
#include "NCSPackets.h"
#endif
#ifndef NCSTIMER_H
#include "NCSTimer.h"
#endif
#ifndef NCSPREFS_H
#include "NCSPrefs.h"
#endif
#ifndef NCSFILEIO_H
#include "NCSFileIO.h"
#endif
#ifndef NCSMISC_H
#include "NCSMisc.h"
#endif

#ifdef MACINTOSH
#include <extras.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

INT32 NCSUtilInitialised();
void NCSUtilInit(void);
void NCSUtilFini(void);
void NCSSleep(NCSTimeStampMs tsSleepTime);
char *NCSStrDup(char *pString);
NCSError NCSFormatCoordStringsEN(double dEasting, double dNorthing, char **ppEastString, char **ppNorthString);
NCSError NCSFormatCoordStringsLL(double dEasting, double dNorthing, char **ppEastString, char **ppNorthString);
UINT32   NCSGetNumCPUs(void);
UINT32 NCSGetNumPhysicalCPUs(void);
#ifdef WIN32
BOOLEAN NCSGetUserAndDomainName(char *UserName, LPDWORD cchUserName, char* DomainName, LPDWORD cchDomainName);
UINT32 NCSGetWebServerID(const char *szPath, DWORD nPathLen);
#endif
BOOLEAN NCSIsNaN(IEEE8 dDoubleValue);
BOOLEAN NCSIsService(void);		/**[04]**/
BOOLEAN NCSIsWebService(void);	/**[05]**/

double NCSNanVal(void);	/**[06]**/
BOOLEAN NCSDoubleIsNan(double v);

#ifdef WIN32
#ifdef _WIN32_WCE

#if (_WIN32_WCE <= 211)
#define strnicmp(a, b, c)	_memicmp(a, b, c)
#define stricmp(a, b)		_memicmp(a, b, MIN(strlen(a), strlen(b)))
#else
#define strnicmp(a, b, c)	_strnicmp(a, b, c)
#define stricmp(a, b)		_stricmp(a, b)
#endif

#endif /* _WIN32_CE */

#define vsnprintf			_vsnprintf
#define snprintf			_snprintf

#define NCSMessageBox(Window, Text, Caption, Type) ::MessageBox(Window, Text, Caption, Type)

#elif defined __PALM__

#define stricmp(a, b)		StrCaselessCompare(a, b)
#define strnicmp(a, b, c)	StrNCaselessCompare(a, b, c)
#define strcmp(a, b)		StrCompare(a, b)
#define strncmp(a, b)		StrNCompare(a, b)
#define strcpy(a, b) 		StrCopy(a, (const char*)b)
#define strncpy(a, b, c)	StrNCopy(a, (const char*)b, c)
#define strlen(a)			StrLen(a)
#define calloc(a, b) 		NCSMalloc(a * b, TRUE)
#define malloc(a)			NCSMalloc(a, FALSE)
#define realloc(a, b)		NCSRealloc((void*)a, b, TRUE)
#define free(a)				NCSFree(a)
#define memcpy(a, b, c)		MemMove(a, b, c)
#define memset(a, b, c)		MemSet(a, c, b)
#define isupper(a)			((((a) >= 'A') && ((a) <= 'Z')) ? TRUE : FALSE)
#define tolower(a)			((a) -= ('A' - 'a'))
int sscanf(const char *string, const char *format, ...);
__inline double atof(char *s) 
{
	double d;
	sscanf(s, "%f", &d);
	return(d);
}


#elif defined MACINTOSH

#if TARGET_API_MAC_CARBON
#	define _stricmp stricmp
#	define _strnicmp strnicmp
#	define _itoa itoa
#else
#	define strncascmp 		_stricmp
#	define NCSstrcasecmp 	_stricmp
#	define strnicmp		_strnicmp
#	define stricmp			_stricmp
#endif //TARGET_API_MAC_CARBON

#else /* __PALM__ */

#define stricmp(a, b) 		strcasecmp(a, b)
#define strnicmp(a, b, c)	strncasecmp(a, b, c)

#endif /* WIN32 */

#ifdef UNICODE

static NCS_INLINE wchar_t *NCSA2WHelper(wchar_t *lpw, const char *lpa, int nChars)
{
	lpw[0] = '\0';
#ifdef WIN32
	MultiByteToWideChar(CP_ACP, 0, (LPSTR)lpa, -1, (LPWSTR)lpw, nChars);
#else
	mbstowcs(lpw, lpa, nChars);
#endif
	return lpw;
}

static NCS_INLINE char *NCSW2AHelper(char *lpa, const wchar_t *lpw, int nChars)
{
	lpa[0] = '\0';
#ifdef WIN32
	WideCharToMultiByte(CP_ACP, 0, (LPWSTR)lpw, -1, (LPSTR)lpa, nChars, NULL, NULL);
#else
	wcstombs(lpa, lpw, nChars);
#endif
	return lpa;
}

#define OS_STRING(lpa)		(((lpa) == NULL) ? NULL : NCSA2WHelper((wchar_t*) alloca(((int)strlen(lpa)+1)*2*sizeof(wchar_t)), (lpa), ((int)strlen(lpa)+1)))
#define CHAR_STRING(lpw)	(((lpw) == NULL) ? NULL : NCSW2AHelper((char*) alloca(((int)wcslen(lpw)+1)*2), (lpw), ((int)wcslen(lpw)+1)*2))

#ifndef WIN32
#define _tcscmp wcscmp

#if defined SOLARIS || defined LINUX || defined MACOSX

#include <wchar.h>
#include <wctype.h>

#endif // SOLARIS || LINUX || MACOSX

#if defined SOLARIS || defined MACOSX

static NCS_INLINE int wcsicmp(const wchar_t *s1, const wchar_t *s2)
{
    while ((*s2 != L'\0') && (towlower(*s1) == towlower(*s2))) {
		s1++;
		s2++;
    }
    return(towlower(*s1) - towlower(*s2));
}

static NCS_INLINE wchar_t *wcsdup(const wchar_t *s1)
{
	size_t len = (wcslen(s1) + 1) * sizeof(wchar_t);
	wchar_t *s2 = (wchar_t*)malloc(len);
	memcpy(s2, s1, len);
	return(s2);
}

#endif // SOLARIS || MACOSX

#endif //!WIN32

#else	/* UNICODE */

#define OS_STRING(lpa)		(lpa)
#define CHAR_STRING(lpw)	(lpw)

#ifndef WIN32
#define _tcscmp strcmp
#endif //!WIN32

#endif	/* UNICODE */

#ifdef __cplusplus
}
#endif

#endif /* NCSUTIL_H */
